/*
 * Decompiled with CFR 0.152.
 */
package net.forixaim.battle_arts.core_assets.skills.active;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public abstract class ActiveSkill
extends Skill {
    protected List<WeaponCategory> allowedWeapons = Lists.newArrayList();
    protected List<Map<AnimationProperty.AttackPhaseProperty<?>, Object>> properties = Lists.newArrayList();
    protected float manaConsumption;
    protected float staminaConsumption;

    public ActiveSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.manaConsumption = parameters.m_128457_("mana_consumption");
        this.staminaConsumption = parameters.m_128457_("stamina_consumption");
    }

    protected boolean manaCheck(PlayerPatch<?> executor) {
        if (ModList.get().isLoaded("irons_spellbooks")) {
            return (float)ClientMagicData.getPlayerMana() >= this.manaConsumption;
        }
        return executor.getStamina() >= (float)Math.round(this.manaConsumption / 10.0f) + this.staminaConsumption;
    }

    protected boolean weaponCategoryMatch(WeaponCategory category) {
        for (WeaponCategory category1 : this.allowedWeapons) {
            if (category1 != category) continue;
            return true;
        }
        return false;
    }

    public boolean canExecute(PlayerPatch<?> executer) {
        ItemStack weapon = ((Player)executer.getOriginal()).m_21205_();
        WeaponCategory weaponCategory = EpicFightCapabilities.getItemStackCapability((ItemStack)weapon).getWeaponCategory();
        if (executer.isLogicalClient()) {
            return super.canExecute(executer);
        }
        ItemStack itemstack = ((Player)executer.getOriginal()).m_21205_();
        return super.canExecute(executer) && this.weaponCategoryMatch(weaponCategory) && ((Player)executer.getOriginal()).m_20202_() == null && (!executer.getSkill((Skill)this).isActivated() || this.activateType == Skill.ActivateType.TOGGLE);
    }

    public void executeOnServer(ServerPlayerPatch executor, FriendlyByteBuf args) {
        if (ModList.get().isLoaded("irons_spellbooks")) {
            MagicData.getPlayerMagicData((LivingEntity)((LivingEntity)executor.getOriginal())).addMana((float)(-Math.round(this.manaConsumption / 10.0f)));
        } else {
            executor.setStamina(executor.getStamina() - (float)Math.round(this.manaConsumption / 100.0f));
        }
        executor.setStamina(executor.getStamina() - this.staminaConsumption);
        super.executeOnServer(executor, args);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
    }

    protected <V> Optional<V> getProperty(AnimationProperty.AttackPhaseProperty<V> propertyKey, Map<AnimationProperty.AttackPhaseProperty<?>, Object> map) {
        return Optional.ofNullable(map.get(propertyKey));
    }

    public ActiveSkill newProperty() {
        this.properties.add(Maps.newHashMap());
        return this;
    }

    public <T> ActiveSkill addProperty(AnimationProperty.AttackPhaseProperty<T> propertyKey, T object) {
        this.properties.get(this.properties.size() - 1).put(propertyKey, object);
        return this;
    }
}

